import enum


class ErrorCodes(enum.Enum):
    UNKNOWN_ERROR = 500, 999999, 'internal server error'
    INVALID_CONTENT_TYPE = 400, 1000, 'invalid content type'
    INTERNAL_ERROR = 500, 1001, 'internal error'
    INPUT_ENCODING_ERROR = 400, 1002, 'input encoding error'
    INVALID_PARAMETERS = 400, 1003, 'invalid parameter(s)'
    NO_RESULT = 400, 1004, 'no result'
    INPUT_TEXT_TOO_LONG = 400, 1005, 'input text too long'
    PARAM_NOT_EXIST = 400, 1006, 'param not exist'

    def __init__(self, status_code, code, message):
        self._status_code = status_code
        self._code = code
        self._message = message

    @property
    def status_code(self):
        return self._status_code

    @property
    def code(self):
        return self._code

    @property
    def message(self):
        return self._message


class YunfuException(Exception):
    '''自定义异常类'''

    def __init__(self, error_code: ErrorCodes, message: str = None):
        self._status_code = error_code.status_code
        code = error_code.code
        message = message if message else error_code.message
        self._json = {'code': code, 'message': message}

    @property
    def status_code(self):
        return self._status_code

    @property
    def json(self):
        return self._json
