# yunfu.common

## utils.py

### PathUtil

- init
  - 初始化方法，传入 PROJECT_ROOT
- get_abs_path
  - 输入相对路径，返回绝对路径

### ConfigUtil

- load_config
  - 输入相对路径配置文件，返回配置字典

### LogUtil

- PROJECT_ROOT 下存在 conf/logging.yaml 时使用该配置，不存在则使用 default_log_conf.py 中的默认配置
- get_logger
  - 输入日志名，返回 logger

## exceptions.py

- ErrorCodes
  包含返回的状态码、错误编码和提示信息
- YunfuException
  根据 ErrorCodes 生成异常，支持修改提示信息。

### 使用方式

```
# 抛出异常
x = func()
if x is None:
    raise YunfuException(ErrorCode.UNKNOWN_ERROR, '未知错误。')
# 捕获异常（django）
try:
    ...
except YunfuException as e:
    logger.exception(e)
    return Response(e.json)
```
