# openapi-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https:////.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https:////.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DefaultApi(api_client)
    username = 'username_example' # str | 
    password = 'password_example' # str | 
    email = 'email_example' # str |  (optional)

    try:
        # Register User
        api_instance.myapi_api_example_form_data_register_user(username, password, email=email)
    except ApiException as e:
        print("Exception when calling DefaultApi->myapi_api_example_form_data_register_user: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**myapi_api_example_form_data_register_user**](docs/DefaultApi.md#myapi_api_example_form_data_register_user) | **POST** /api/form-data/register_user | Register User
*DefaultApi* | [**myapi_api_example_form_data_upload_item_with_file**](docs/DefaultApi.md#myapi_api_example_form_data_upload_item_with_file) | **POST** /api/form-data/upload_item | Upload Item With File
*DefaultApi* | [**myapi_api_example_path_parameters_get_item_by_id**](docs/DefaultApi.md#myapi_api_example_path_parameters_get_item_by_id) | **GET** /api/path-params/items/{item_id} | Get Item By Id
*DefaultApi* | [**myapi_api_example_path_parameters_get_user_order**](docs/DefaultApi.md#myapi_api_example_path_parameters_get_user_order) | **GET** /api/path-params/users/{user_id}/orders/{order_id} | Get User Order
*DefaultApi* | [**myapi_api_example_query_parameters_list_items_by_query**](docs/DefaultApi.md#myapi_api_example_query_parameters_list_items_by_query) | **GET** /api/query-params/items_by_query | List Items By Query
*DefaultApi* | [**myapi_api_example_query_parameters_search_products**](docs/DefaultApi.md#myapi_api_example_query_parameters_search_products) | **GET** /api/query-params/search_products | Search Products
*DefaultApi* | [**myapi_api_hello**](docs/DefaultApi.md#myapi_api_hello) | **POST** /api/hello | Hello


## Documentation For Models

 - [HelloSchema](docs/HelloSchema.md)
 - [ItemFilter](docs/ItemFilter.md)
 - [ItemSchema](docs/ItemSchema.md)
 - [MessageSchema](docs/MessageSchema.md)
 - [UploadItem](docs/UploadItem.md)
 - [UserIn](docs/UserIn.md)
 - [UserOrderSchema](docs/UserOrderSchema.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




