#! /usr/bin/env python
# -*- coding: utf-8 -*_
# Author: Liu Yang <mkliuyang@gmail.com>

from dlab.config import add_config, inherit_config, MacroReplaceManager


@add_config('a1', str, 'a1', 'a1 desc.')
@add_config('a2', str, 'a2', 'a2 desc.')
class A(object):
    def __init__(self, config, a3='a3'):
        self.a1 = config['a1']
        self.a2 = config['a2']
        self.a3 = a3

    def __repr__(self):
        return f'<object:A a1="{self.a1}" a2="{self.a2}" a3="{self.a3}">'


@inherit_config(A)
@add_config('b1', str, 'b1', 'b1 decs.')
def B(config, b2='b2'):
    b1 = config['b1']
    a = A('b.a3')
    print(f'<function:B b1="{b1}" b2="{b2}" a="{a.__repr__()}">')


def test_macro():
    manager = MacroReplaceManager()
    manager.add_replacement('CONFIG_DIR', 'abc')
    manager.add_replacement('CONFIG_FILE', 'def')

    print(manager.replace('[[CONFIG_DIR]]/lll/kkk'))
    print(manager.replace('lll/kkk'))
    print(manager.replace('[[CONFIG_DIR]]/lll/[[CONFIG_FILE]]/kkk'))


if __name__ == '__main__':
    test_macro()
