#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Author: Liu Yang <mkliuyang@gmail.com>

"""
这部分描述的是"层"，这些层是模型的一部分。根据 ``pytorch`` 的规范，也是继承 ``pytorch.nn.Module``，但是这部分与 `dlab.model package`_ 中
的模型不同，不能独立完成一个任务，而要通过组合形成 `dlab.model package`_ 的模型才能独立的进行某项任务的预测。
"""

from .rnn import URNN, UGRU, ULSTM
from .crf import CRF
from .seq2seq import Decoder

__all__ = ['URNN', 'UGRU', 'ULSTM',
           'Decoder',
           'CRF']

