#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Author: Liu Yang <mkliuyang@gmail.com>

"""
------------------------------------------------
使用dlab的可执行的预制模型套餐进行训练
------------------------------------------------

dlab在这个层级上使用更为贴近业务（任务）的概念进行封装，可以使用函数或命令行接口进行训练、测试、预测、上线。

``dlab.exe`` 模块中每个子模块对应一个任务，每个任务有如下函数接口：

- ``train`` 训练接口，每个任务的训练参数是不同的。但不同任务的其他接口基本相同。
- ``evaluate`` 测试，在测试集上评价指标
- ``predict`` 数据文件预测，可以一次预测一个文件的全部数据，比服务接口更快。
- ``server`` 启动服务，每次预测一个句子
- ``get_model`` 得到dlab model，仅为函数接口，对接代码使用。不能在命令行模式使用。

-------------------------
模型训练
-------------------------

模型的训练根据不同任务有不同的参数选项和数据文件的配置，请到各个接口中查看其相应的实现方法。

已经实现的任务（子模块）如下，详细的训练文档见相应模块内部train方法文档。在那里你可以看到每个任务的详细使用参数与应准备的数据格式。

- `dlab.exe.ner module`_ 实体识别
- `dlab.exe.event module`_ 事件抽取
- `dlab.exe.rel module`_ 关系抽取
- `dlab.exe.tc module`_ 文本分类

------------------------------------------------
通用的测试、预测、上线接口
------------------------------------------------

由于dlab的配置文件通用化能力，我们得以构造几乎相同的测试、预测、上线接口。
这些可以参考 ``dlab.exe.common`` 中的 ``predict``, ``evaluate``, ``server`` 方法文档使用。

另外通过通用的 `get_model(save_dir: str)` 方法，可以获得dlab中的模型，嵌入你需要的业务逻辑进行开发。例如如下的实体识别示例::

    from dlab.exe.ner import Ner
    # 训练
    Ner().train('saves/ner',
                    train_file='data/pku.ner.train.conll',
                    dev_file='data/pku.ner.train.conll',
                    test_file='data/pku.ner.train.conll',
                    entity_names='Nh,Ns,Ni',
                    other_feature_num=1,
                    bert_model='data/models/bert-base-chinese'
                    )
    # 测试
    Ner().evaluate('saves/ner', eval_file='data/pku.ner.train.conll')  # 每次重新构造 `Ner()` 即可，不可与其他任务接口同时运行，线程不安全。
    # 预测
    Ner().predict('saves/ner', src_file='data/pku.ner.train.conll', dist_file='saves/ner/pku.ner.pred.conll')

由于这些方法操作dlab的全局配置，不能保证在构造时线程安全。尽量保证每个程序中仅加载一个模型，每次使用时应该独立的构造这些任务的类对象，
这不会影响性能。

------------------------------------------------
命令行与函数的对应使用方式
------------------------------------------------

命令行函数对接使用的是 `google/python-fire <https://github.com/google/python-fire/blob/master/docs/guide.md>`_
（你可以在这里看到其全部的使用方法）。使用类的接入方式。以上介绍的每一个方法（除get_model以外），可以直接命令行运行，其使用的参数通过命令行参数输入。

例如，如果你希望直接运行 `通用的测试、预测、上线接口`_ 中使用``python``函数描述的过程，可以直接使用如下的命令行指令::

    # 训练
    python -m dlab.exe.ner train 'saves/ner' --train-file='data/pku.ner.train.conll'  \
        --dev-file='data/pku.ner.train.conll'  \
        --test-file='data/pku.ner.train.conll'  \
        --entity-names='Nh,Ns,Ni'  \
        --other-feature_num=1  \
        --bert-model='data/models/bert-base-chinese'
    # 测试
    python -m dlab.exe.ner evaluate 'saves/ner' --eval-file='data/pku.ner.train.conll'
    # 预测
    python -m dlab.exe.ner predict 'saves/ner' --src-file='data/pku.ner.train.conll'  \
        --dist_file='saves/ner/pku.ner.pred.conll'


注意，在传入命令行参数是参数名中的下划线均使用中划线代替。

可以使用如下指令模板调用::

    python -m dlab.exe.<task_name> <function_name> -- --help  # 查看帮助与参数输入
    python -m dlab.exe.<task_name> <function_name> --arg1 value1 ...  # 使用参数接口


+------------------------+------------------------------------------+
| task_name              | function_name                            |
+========================+==========================================+
| ner                    | train / predict / evaluate / server      |
+------------------------+------------------------------------------+
| event                  | train / predict / evaluate / server      |
+------------------------+------------------------------------------+

------------------------------------------------
**For Developers
------------------------------------------------

注意：

- ``google/python-fire`` 库会将,分割的字符串转换为``tuple``，注意处理。参考 ``Ner::train`` 的处理方法。

"""