#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Author: Liu Yang <mkliuyang@gmail.com>

from argparse import ArgumentParser

from dlab.data.structures import Dictionary


def print_dictionary(filename):
    """
    查看字典中保存的内容 [命令行模块接口]

    :param filename: 字典文件位置

    Example::

        python -m dlab.debug.dictionary path/to/some.dict

    """
    d = Dictionary.load_from_file(filename)
    print(d.idx2item)


if __name__ == '__main__':
    parser = ArgumentParser(description='Show the dictionary information.')
    parser.add_argument('filename', type=str, help='path to dictionary file.')
    args = parser.parse_args()
    print_dictionary(args.filename)
