#! /usr/bin/env python
# -*- coding: utf-8 -*_
# Author: Liu Yang <mkliuyang@gmail.com>
"""
data 模块
================

处理数据的各种类和方法。
"""

from .language import LANG
from .reader import CorpusReader, LineBasedTCCorpusReader, WordSegmentCorpusReader, TagCorpusReader, LabelCorpusReader,\
                    DocumentCorpusReader, \
                    BatchedCorpus, \
                    DataSet, LabelDataSet, SeqTagDataSet
from .structures import Dictionary, HierarchicalDictionary, Label, Token, Sentence
from .utils import pad_batch, write_tag_sentence, fit_dict, EarlyStopping, read_embedding

__all__ = ["LANG",
           "CorpusReader", "LineBasedTCCorpusReader", "WordSegmentCorpusReader", "TagCorpusReader", "LabelCorpusReader",
           "DocumentCorpusReader",
           "BatchedCorpus",
           "DataSet", "LabelDataSet", "SeqTagDataSet",
           "Dictionary", "HierarchicalDictionary", "Label", "Token", "Sentence",
           "pad_batch", "write_tag_sentence", "fit_dict", "EarlyStopping", "read_embedding"]